﻿using iText.Html2pdf.Attach;
using iText.Html2pdf.Attach.Impl;
using iText.Html2pdf.Html;
using iText.Html2pdf.Html.Node;
using iText.Kernel.Pdf.Tagging;

namespace NVCC.WebUI.Infrastructure.iTextCustom
{
    /// <summary>
    /// Converted from the Java example at https://developers.itextpdf.com/content/itext-7-examples/itext-7-converting-html-pdf/pdfhtml-accessible-pdf-creation
    /// </summary>
    public class AccessibilityTagWorkerFactory : DefaultTagWorkerFactory
    {
        public override ITagWorker GetCustomTagWorker(IElementNode tag, ProcessorContext context)
        {
            bool hasClass = false;
            foreach (var attribute in tag.GetAttributes())
            {
                if (attribute.GetKey() == "class")
                {
                    hasClass = true;
                    break;
                }
            }
            if (hasClass)
            {
                if (tag.GetAttribute(AttributeConstants.CLASS).Contains("make-h1"))
                {
                    return new ProperHTagWorker(tag, context, StandardRoles.H1);
                }
                if (tag.GetAttribute(AttributeConstants.CLASS).Contains("make-table-div"))
                {
                    return new DivRoleTableTagWorker(tag, context);
                }
                if (tag.GetAttribute(AttributeConstants.CLASS).Contains("make-proper-h2"))
                {
                    return new ProperHTagWorker(tag, context, StandardRoles.H2);
                }
            }

            if (tag.Name() == "th")
            {
                return new ThWithScopeTagWorker(tag, context);
            }
            if (tag.Name() == "h2")
            {
                return new ProperHTagWorker(tag, context, StandardRoles.H2);
            }

            return base.GetCustomTagWorker(tag, context);
        }
    }
}